using System;
using Server;
using Server.Network;

namespace Server.Items
{
	public class GTele1 : PeerlessKey
	{	
		public override int Lifespan{ get{ return 3600; } }
	
		[Constructable]
		public GTele1() : base( 6249 )
		{
			Weight = 1152;
			Stackable = false;
			Name = "A Level 1 Gauntlet Stone";
			Weight = 1.0;
			Amount = 1;
			Hue = 1152;
		}
		
		public override void OnDoubleClick( Mobile from )
		{  
			if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			} 
			else
			{
				from.SendMessage( "Welcome to the first level of the Gauntlet of Horrors" );

				CityInfo city = new CityInfo( "Gauntlet", "Area1", 5276, 1164, 0 ); 
				from.Location = city.Location;
				from.Map = Map.Trammel;

				this.Delete();
			}

		}

		public GTele1( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}

